﻿function checkFlag( spriteFlag, flagRoot )
{
	#include "getPathValue.as"
	// requiring a non-existant condition = fail
	if(spriteFlag === undefined)		return false;
	
	var output = true;			// returns boolean "false" when a flag fails a test
	var flagParts_array = getFlagParts( spriteFlag );
	var variable = flagParts_array[0];
	var operation = flagParts_array[1];
	var value = flagParts_array[2];
	//var value = nestedEval( flagParts_array[2], "RAM", "RAM" );
	
	// convert value into likely datatype
	// // number
	if( isNaN(value)==false )
		value = Number(value);
	// // boolean
	if( value=="true" )
		value = true;
	if( value=="false" )
		value = false;
	// // undefined
	if( value=="undefined" )
		value = undefined;
	// // string
	// already a string by default
	
	// separate variable name from variable path
	/*
	var endAt = variable.lastIndexOf(".");
	if( endAt != -1 )
	{// if:  there is an object path
		var flagPath = variable.substr(0, endAt);			// myObj.anotherObject
		var flagName = variable.substr( endAt+1 );		// myVar
		var flagPath = "flagRoot."+flagPath;					// flagRoot.myObj.anotherObject
	}// if:  there is an object path
	else
	{// if:  there are no preceeding objects
		var flagName = variable;
		var flagPath = "flagRoot";
	}// if:  there are no preceeding objects
	//var displayValue = eval(flagPath+"."+flagName);
	*/
	var displayValue = getPathValue( variable, flagRoot );
	
	// check specified contents, in the specified ways
	switch( operation )
	{
		case "!":
			output = ( displayValue == undefined  ||  displayValue == false );		// these values return as true
			//trace("  displayValue: "+displayValue+"  ("+typeof(displayValue)+")  =  "+output);
		break;
		case "=":
			output = ( displayValue == value );
		break;
		case "!=":
			// read "myVar != undefined" as TRUE when   myVar actually equals "false"
			if( !Boolean(displayValue) && !Boolean(value) ){
				displayValue = false;
				value = false;
			}
			output = ( displayValue != value );
		break;
		case "<":
			output = ( displayValue < value );
			if(displayValue==undefined){	output=false		};					// undefined normally returns true
			if(typeof(displayValue)=="string"){	output=false		};		// strings normally return true
		break;
		case ">":
			output = ( displayValue > value );
			if(displayValue==undefined){	output=false		};					// undefined normally returns true
			if(typeof(displayValue)=="string"){	output=false		};		// strings normally return true
		break;
		case "<=":
			output = ( displayValue <= value );
			if(displayValue==undefined){	output=false		};					// undefined normally returns true
			if(typeof(displayValue)=="string"){	output=false		};		// strings normally return true
		break;
		case ">=":
			output = ( displayValue >= value );
			if(displayValue==undefined){	output=false		};					// undefined normally returns true
			if(typeof(displayValue)=="string"){	output=false		};		// strings normally return true
		break;
	}// case:  operation
	
	
//		trace("\t\t "+output+" ("+displayValue+" "+operation+" "+value+")" );
	return output;
	
	
	
	// _______________________________________________________________________________
	function getFlagParts( flag )
	{// convert "myFlag" to "myFlag != undefined"		"!myFlag" to "myFlag = undefined"		"myFlag>2" to "myFlag > 2"
		var parts_array = [];
		
		// remove space from beginning of flag
		var firstChar = flag.charAt(0);
		while(firstChar==" "){
			flag = flag.substr(1);		// chop off first character
			firstChar = flag.charAt(0);
		}// while:  space exists at the beginning
		
		
		// remove space from end of flag
		var lastChar = flag.charAt( flag.length-1 );
		while(lastChar==" "){
			flag = flag.substr(0, flag.length-1);		// chop off last character
			lastChar = flag.charAt( flag.length-1 );
		}// while:  space exists at the end
		
		
		// catch:  !myFlag
		if( flag.charAt(0) == "!" ){
			flag = flag.substr(1)+"!";
			var endAt = flag.indexOf("!");
			var startAt = endAt+1;
		}// if:  flag starts with !
		else if( flag.indexOf("!=") != -1 ){
			var endAt = flag.indexOf("!=");
			var startAt = endAt+2;
		}
		else if( flag.indexOf("<=") != -1 ){
			var endAt = flag.indexOf("<=");
			var startAt = endAt+2;
		}
		else if( flag.indexOf(">=") != -1 ){
			var endAt = flag.indexOf(">=");
			var startAt = endAt+2;
		}
		else if( flag.indexOf("<") != -1 ){
			var endAt = flag.indexOf("<");
			var startAt = endAt+1;
		}
		else if( flag.indexOf(">") != -1 ){
			var endAt = flag.indexOf(">");
			var startAt = endAt+1;
		}
		else if( flag.indexOf("=") != -1 ){
			var endAt = flag.indexOf("=");
			var startAt = endAt+1;
		}
		else{// if:  there's no operator
			var endAt = flag.length;
			flag = flag+"!=undefined"
			var startAt = endAt+2;
		}// if:  there's no operator
		
		parts_array.push(flag.substr( 0, endAt ));					// [0]	myFlag
		parts_array.push(flag.substring( endAt, startAt ));	// [1]	!=
		parts_array.push(flag.substr( startAt ));						// [2]	"merf"
		
		// remove space from end of flag name
		var lastChar = parts_array[0].charAt( parts_array[0].length-1 );
		while(lastChar==" "){
			parts_array[0] = parts_array[0].substr(0, parts_array[0].length-1);		// chop off last character
			lastChar = parts_array[0].charAt( parts_array[0].length-1 );
		}// while:  space exists at the end
		// remove space from beginning of value
		var firstChar = parts_array[2].charAt(0);
		while(firstChar==" "){
			parts_array[2] = parts_array[2].substr(1);		// chop off first character
			firstChar = parts_array[2].charAt(0);
		}// while:  space exists at the beginning
		
		return parts_array;
	}// getFlagParts()
}// checkFlag()